using System;

using gov.va.med.vbecs.GUI.controls;
using gov.va.med.vbecs.Lock;
using System.Threading;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI.Lock
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stas Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>3/18/2005</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	/// VBECS application startup lock class. Ensures that only one instace of 
	/// the VBECS can run in the user session and that VBECS is not run when 
	/// there is the VBECS Administrator running on the server in single user mode.
	/// </summary>

	#endregion

	public class VbecsAppStartupLock : SyncLockBase
	{
		/// <summary>
		/// Local VBECS application synchronization token (mutex name).
		/// Used to indicate that VBECS application is running in the user session.
		/// </summary>
		private const string LocalVbecsSyncToken = "gov.va.med.vbecs.LocalVbecsInSessionSyncLockToken";

        private Mutex _vbecsLocalMutex;
        private SharedMutex _vbecsGlobalMutex;

		/// <summary>
		/// Creates new locks and checks if there're an existing locks.
		/// </summary>
		public VbecsAppStartupLock() : base() 
        {}
        /// <summary>
        /// Creates new locks and checks if there's another instance of VBECS running in the user session..
        /// </summary>
        protected override void Init()
        {
            base.Init();
            // check if there's another instance of VBECS running in the user session.
            bool onlyOneInstanceOfVbecsIsRunningInSession;
            _vbecsLocalMutex = new Mutex(true, LocalVbecsSyncToken, out onlyOneInstanceOfVbecsIsRunningInSession);
            if (!onlyOneInstanceOfVbecsIsRunningInSession)
                throw new AppLockingException(StrRes.SysErrMsg.UC018.VbecsIsAlreadyRunning());
        }

		/// <summary>
		/// Obtains new locks and checks for existing locks. 
		/// </summary>
		protected override void ObtainAppSpecificGlobalLocks()
		{
            // Check if there's an instance of VBECS Administrator running in single user mode on the server.
            // 'Using' statement will make sure that created object will be disposed
            bool adminIsNotRunningInSingleUserMode;
            using (new SharedMutex(Common.VbecsConfig.Current.EnvironmentType.ToUpper() == "M" ? GlobalAdminTestSingleUserModeSyncToken : GlobalAdminProdSingleUserModeSyncToken, out adminIsNotRunningInSingleUserMode))
            {}
            if (!adminIsNotRunningInSingleUserMode)
                throw new AppLockingException(StrRes.SysErrMsg.UC018.VbecsAdministratorIsRunningInTheSingleUserMode());

            // Open mutex to signal that VBECS is running
            _vbecsGlobalMutex = new SharedMutex(Common.VbecsConfig.Current.EnvironmentType.ToUpper() == "M" ? GlobalTestVbecsSyncToken : GlobalProdVbecsSyncToken);
		}

		/// <summary>
		/// Releases locks.
		/// </summary>
		protected override void ReleaseAppSpecificGlobalLocks()
		{
            if (_vbecsGlobalMutex != null) 
                _vbecsGlobalMutex.Dispose();
            if (_vbecsLocalMutex != null)
                _vbecsLocalMutex.Dispose();
		}
	}
}